pro for_plotfitsdefaults,gridtype,ngrid,line=line,typekcor=typekcor,kcor=kcor,$
	     punch=punch,aspiics=aspiics,$
	     colortable=colortable,plotlog=plotlog,imax=imax,imin=imin,psplot=psplot,$
             usecolor=usecolor,axiscolor=axiscolor,docont=docont,nocontcolor=nocontcolor,noclabel=noclabel,nlev=nlev,$
             c_charsize=c_charsize,winnumber=winnumber,nwinx=nwinx,nwiny=nwiny,bgcolor=bgcolor,$
             dispexp=dispexp,dispgamma=dispgamma,rpow=rpow,nobangletitle=nobangletitle,$
             charsize=charsize,charthick=charthick,noerase=noerase,title=title,$
             whitedisk=whitedisk,nulldatacolor=nulldatacolor,sunedge=sunedge,rfilter=rfilter,$
             stklines=stklines,nstarrow=nstarrow,arrowave=arrowave,extratitle=extratitle,$
	     aia=aia,ucomp=ucomp,wlcomp=wlcomp,$
	     gif=gif,tiff=tiff,jpeg=jpeg,moreplots=moreplots

;+
;
; program to set up defaults for plotfits
;	generally overwritten by for_drive, for_widget
; 	so really only important when for_plotfits called on its own
;
; Inputs:
;        gridtype,ngrid
;	 keywords: line,typekcor,kcor
;	 needed for conditionals below
; Outputs:
;	 (for_plot keywords -- others set elsewhere)
;	colortable,plotlog,imax,imin,psplot,usecolor,axiscolor,docont,nocontcolor,noclabel,nlev,c_charsize
;   	winnumber,nwinx,nwiny,bgcolor,dispexp,dispgamma,rpow,charsize,charthick,noerase,title
;	whitedisk,nulldatacolor,sunedge,rfilter
;	 
;        (for_plotstokeslines keywords)
;	stklines,nstarrow,arrowave
;
;	  (for_saveplot keywords
; 	gif,tiff,jpeg
;
;	 (not really used but in case
;	moreplots	
;
; Called by for_plotfits
;
; Written by Sarah Gibson 2021
;
; Sept 2021 -- expanded conditional test for STOKESQOI etc
; Jan 2022 -- added usecolor defaults for L, Q, U
; Jun 2022 -- added nobangletitle
; Feb 2024 -- commented out forced AIA docont=0
; Mar 2024 -- changed LoI minimum to -2 to be consistent with UCoMP on web
; Jan 2025 -- changed imin/imax for MLSO
;		passed through wlcomp and ucomp keywords
;		moved datastart forcings here instead of for_plotdefaults
; June 2025 -- changed KCOR default to quarterpower_filter
; July 2025 -- started adding hooks for punch, aspiics
; winter 2025/2026 changed some defaults for plotlog
;	added then removed donoise/cimin/maxthres -- dealt with
;	now in main defaults and for_plotfits.
;  set comp/ucomp default plotlog, and only set imin/imax if force plotlog=0

common forward,flag,variables,settings,plotops,losops,gridops,widgets,obsops,modops,strings,outops

datastart=flag.dta

if keyword_set(line) then begin
 if strupcase(line) eq 'STOKESI' then begin
  default,usecolor,7777
  if datastart ne 0 then usecolor=7777 
  if strupcase(gridtype) eq 'PLANEOFSKY' then begin
   default,plotlog,1
   if datastart ne 0 then plotlog=1
   if plotlog eq 0 then begin
    if ucomp eq 1 then begin
     if strpos(strupcase(wlcomp),'530') ge 0 then begin
      default,imin,0.3
      default,imax,80.
      if datastart ne 0 then imin=0.3
      if datastart ne 0 then imax=80.
     endif
     if strpos(strupcase(wlcomp),'637') ge 0 then begin
      default,imin,0.
      default,imax,15.
      if datastart ne 0 then imin=0.
      if datastart ne 0 then imax=15.
     endif
     if strpos(strupcase(wlcomp),'656') ge 0 then begin
      default,imin,0.
      default,imax,800.
      if datastart ne 0 then imin=0.
      if datastart ne 0 then imax=800.
     endif
     if strpos(strupcase(wlcomp),'670') ge 0 then begin
      default,imin,0.
      default,imax,10.
      if datastart ne 0 then imin=0.
      if datastart ne 0 then imax=10.
     endif
     if strpos(strupcase(wlcomp),'691') ge 0 then begin
      default,imin,0.
      default,imax,3.
      if datastart ne 0 then imin=0.
      if datastart ne 0 then imax=3.
     endif
     if strpos(strupcase(wlcomp),'706') ge 0 then begin
      default,imin,0.
      default,imax,3.
      if datastart ne 0 then imin=0.
      if datastart ne 0 then imax=3.
     endif
     if strpos(strupcase(wlcomp),'761') ge 0 then begin
      default,imin,0.
      default,imax,10.
      if datastart ne 0 then imin=0.
      if datastart ne 0 then imax=10.
     endif
     if strpos(strupcase(wlcomp),'789') ge 0 then begin
      default,imin,0.
      default,imax,15.
      if datastart ne 0 then imin=0.
      if datastart ne 0 then imax=15.
     endif
     if strpos(strupcase(wlcomp),'802') ge 0 then begin
      default,imin,0.
      default,imax,10.
      if datastart ne 0 then imin=0.
      if datastart ne 0 then imax=10.
     endif
     if strpos(strupcase(wlcomp),'991') ge 0 then begin
      default,imin,0.
      default,imax,15.
      if datastart ne 0 then imin=0.
      if datastart ne 0 then imax=15.
     endif
     if strpos(strupcase(wlcomp),'1074') ge 0 then begin
      default,imin,0.
      default,imax,40.
      if datastart ne 0 then imin=0.
      if datastart ne 0 then imax=40.
     endif
     if strpos(strupcase(wlcomp),'1079') ge 0 then begin
      default,imin,0.
      default,imax,20.
      if datastart ne 0 then imin=0.
      if datastart ne 0 then imax=20.
     endif
     if strpos(strupcase(wlcomp),'1083') ge 0 then begin
      default,imin,0.
      default,imax,1500.
      if datastart ne 0 then imin=0.
      if datastart ne 0 then imax=1500.
     endif
    endif else begin
     if strpos(strupcase(wlcomp),'1074') ge 0 then begin
      default,imin,0.
      default,imax,16.
      if datastart ne 0 then imin=0.
      if datastart ne 0 then imax=16.
     endif
     if strpos(strupcase(wlcomp),'1079') ge 0 then begin
      default,imin,0.
      default,imax,14.6
      if datastart ne 0 then imin=0.
      if datastart ne 0 then imax=14.6
     endif
     if strpos(strupcase(wlcomp),'1083') ge 0 then begin
      default,imin,0.
      default,imax,3956.0
      if datastart ne 0 then imin=0.
      if datastart ne 0 then imax=3956.0
     endif
    endelse
   endif else begin
     default,imin,'scaled to data'
     default,imax,'scaled to data'
     if datastart ne 0 then imin='scaled to data'
     if datastart ne 0 then imax='scaled to data'
   endelse
  endif
 endif
 if strupcase(line) eq 'STOKESQ' or strupcase(line) eq 'STOKESU' or strupcase(line) eq 'STOKESL' then begin
  default,plotlog,0
  if datastart ne 0 then plotlog=0
  if strupcase(line) eq 'STOKESL' then begin
    default,usecolor,0 
    if datastart ne 0 then usecolor=0
  endif else begin
    default,usecolor,42
    if datastart ne 0 then usecolor=42
  endelse
  if strupcase(gridtype) eq 'PLANEOFSKY' then begin
   if plotlog eq 0. then begin
    if strpos(strupcase(wlcomp),'1079') ge 0 then begin
;  check this
     default,imin,-.2
     default,imax,.2
     if datastart ne 0 then imin=-.2
     if datastart ne 0 then imax=.2
    endif else begin
     default,imin,-1.
     default,imax,1.
     if datastart ne 0 then imin=-1.
     if datastart ne 0 then imax=1.
    endelse
   endif
  endif
 endif
 if strpos(strupcase(line),'OI') ge 0 then begin
  if strpos(strupcase(line),'LOI') ge 0 then begin
   default,plotlog,1
   if datastart ne 0 then plotlog=1
   if strupcase(gridtype) eq 'PLANEOFSKY' then begin
    if plotlog eq 1 then begin
     if ucomp eq 1 then begin
      default,imin,-2.
      default,imax,-.3
     if datastart ne 0 then imin=-2.
     if datastart ne 0 then imax=-.3
     endif else begin
      default,imin,-2.3
      default,imax,-.3
     if datastart ne 0 then imin=-2.3
     if datastart ne 0 then imax=-.3
     endelse
    endif
   endif
  endif else begin
   default,plotlog,0
   if datastart ne 0 then plotlog=0
   if strupcase(gridtype) eq 'PLANEOFSKY' then begin
    if plotlog eq 0 then begin
     if strpos(strupcase(wlcomp),'1079') ge 0 then begin
      default,imin,-.1
      default,imax,.1
     if datastart ne 0 then imin=-.1
     if datastart ne 0 then imax=.1
     endif else begin
      default,imin,-.2
      default,imax,.2
     if datastart ne 0 then imin=-.2
     if datastart ne 0 then imax=.2
     endelse
    endif
   endif
  endelse
 endif
 if strupcase(line) eq 'DOPPLERVLOS' then begin
  default,usecolor,42
  default,plotlog,0
  if datastart ne 0 then usecolor=42
  if datastart ne 0 then plotlog=0
  if strupcase(gridtype) eq 'PLANEOFSKY' then begin
   if plotlog eq 0 then begin
    if ucomp eq 1 then begin
     default,imin,-5.
     default,imax,5.
     if datastart ne 0 then imin=-5.
     if datastart ne 0 then imax=5.
    endif else begin
     default,imin,-10.
     default,imax,10.
     if datastart ne 0 then imin=-10.
     if datastart ne 0 then imax=10.
    endelse
   endif
  endif
 endif
 if strupcase(line) eq 'LINEWIDTH' then begin
  default,usecolor,4
  default,plotlog,0
  if datastart ne 0 then usecolor=4
  if datastart ne 0 then plotlog=0
  if strupcase(gridtype) eq 'PLANEOFSKY' then begin
   if plotlog eq 0 then begin 
    if ucomp eq 0 then begin
     default,imin,54.
     default,imax,74.
     if datastart ne 0 then imin=54.
     if datastart ne 0 then imax=74.
    endif else begin
     if strpos(strupcase(wlcomp),'530') ge 0 then begin
      default,imin,43.
      default,imax,66.
      if datastart ne 0 then imin=43.
      if datastart ne 0 then imax=66.
     endif
     if strpos(strupcase(wlcomp),'637') ge 0 then begin
      default,imin,35.
      default,imax,61.
      if datastart ne 0 then imin=35.
      if datastart ne 0 then imax=61.
     endif
     if strpos(strupcase(wlcomp),'656') ge 0 then begin
      default,imin,40.
      default,imax,90.
      if datastart ne 0 then imin=40.
      if datastart ne 0 then imax=90.
     endif
     if strpos(strupcase(wlcomp),'670') ge 0 then begin
      default,imin,40.
      default,imax,90.
      if datastart ne 0 then imin=40.
      if datastart ne 0 then imax=90.
     endif
     if strpos(strupcase(wlcomp),'691') ge 0 then begin
      default,imin,40.
      default,imax,90.
      if datastart ne 0 then imin=40.
      if datastart ne 0 then imax=90.
     endif
     if strpos(strupcase(wlcomp),'706') ge 0 then begin
      default,imin,48.
      default,imax,69.
      if datastart ne 0 then imin=48.
      if datastart ne 0 then imax=69.
     endif
     if strpos(strupcase(wlcomp),'761') ge 0 then begin
      default,imin,40.
      default,imax,90.
      if datastart ne 0 then imin=40.
      if datastart ne 0 then imax=90.
     endif
     if strpos(strupcase(wlcomp),'789') ge 0 then begin
      default,imin,41.
      default,imax,65.
      if datastart ne 0 then imin=41.
      if datastart ne 0 then imax=65.
     endif
     if strpos(strupcase(wlcomp),'802') ge 0 then begin
      default,imin,40.
      default,imax,90.
      if datastart ne 0 then imin=40.
      if datastart ne 0 then imax=90.
     endif
     if strpos(strupcase(wlcomp),'991') ge 0 then begin
      default,imin,40.
      default,imax,90.
      if datastart ne 0 then imin=40.
      if datastart ne 0 then imax=90.
     endif
     if strpos(strupcase(wlcomp),'1074') ge 0 then begin
      default,imin,54.
      default,imax,74.
      if datastart ne 0 then imin=54.
      if datastart ne 0 then imax=74.
     endif
     if strpos(strupcase(wlcomp),'1079') ge 0 then begin
      default,imin,54.
      default,imax,74.
      if datastart ne 0 then imin=54.
      if datastart ne 0 then imax=74.
     endif
     if strpos(strupcase(wlcomp),'1083') ge 0 then begin
      default,imin,40.
      default,imax,90.
      if datastart ne 0 then imin=40.
      if datastart ne 0 then imax=90.
     endif
    endelse
   endif
  endif
 endif
 if strpos(strupcase(line),'AZ') ge 0 then begin
  default,usecolor,66
  default,plotlog,0
  if datastart ne 0 then usecolor=66
  if datastart ne 0 then plotlog=0
  if strupcase(gridtype) eq 'PLANEOFSKY' then begin
   if plotlog eq 0 then begin 
    default,imin,-90.
    default,imax,90.
    if datastart ne 0 then imin=-90.
    if datastart ne 0 then imax=90.
   endif
  endif
 endif
endif

if keyword_set(kcor) or keyword_set(punch) or keyword_set(aspiics) then begin
 default,imin,'scaled to data'
 default,imax,'scaled to data'
 if strupcase(typekcor) eq 'EXTAVG' then begin
  default,dispgamma,.7
  default,dispexp,.7
  default,rfilter,'quarterpower_filter'
  default,plotlog,0
  if datastart ne 0 then begin
   dispgamma=.7
   dispexp=.7
   rfilter='quarterpower_filter'
   plotlog=0
  endif
 endif
 if strupcase(typekcor) eq 'FIRSTL1' then begin
  default,rfilter,'no_filter'
  default,plotlog,1
  if datastart ne 0 then begin
   rfilter='no_filter'
   plotlog=1
  endif
 endif
endif

default,dispgamma,1.
default,dispexp,1.
default,rpow,3
default,nobangletitle,0
if datastart ne 0 then begin
   dispgamma=1.
   dispexp=1.
   rpow=3
   nobangletitle=0
endif

if strupcase(gridtype) eq 'CARRMAP' then begin
  rfilter='no_filter'
  default,nwinx,720
  default,nwiny,360
  default,plotlog,0
  if datastart ne 0 then begin
   nwinx=720
   nwiny=360
   plotlog=0
  endif
    if keyword_set(charsize) eq 0 then $
                if !p.charsize eq 0 then charsize=1.d0 else charsize=!p.charsize
    if keyword_set(charthick) eq 0 then $
                if !p.charthick eq 0 then charthick=1.d0 else charthick=!p.charthick
    default,c_charsize,2.*charsize/3.
    if datastart ne 0 then c_charsize=2.*charsize/3.
endif else begin
    if keyword_set(charsize) eq 0 then $
                if !p.charsize eq 0 then charsize=1.5d0 else charsize=!p.charsize
    if keyword_set(charthick) eq 0 then $
                if !p.charthick eq 0 then charthick=1.5d0 else charthick=!p.charthick
    default,c_charsize,2.*charsize/3.
    if datastart ne 0 then c_charsize=2.*charsize/3.
    if datastart ne 0 then begin
     nwinx=750
     nwiny=750
    endif
endelse

;
; may need to datastart force these below too, but maybe not (if done in for_plotfits)
;  I think these are for when for_plotfits is run standalone vs in widget
;
default,colortable,1
default,imax,'scaled to data'
default,imin,'scaled to data'
default,psplot,0
default,gif,0
default,tiff,0
default,jpeg,0
if keyword_set(aia) then default,usecolor,7777. else default,usecolor,0
default,rfilter,'no_filter'
if strupcase(rfilter) eq 'AIA_RFILTER' and keyword_set(aia) eq 0 then rfilter='no_filter'
default,plotlog,1

default,bgcolor,1
if bgcolor eq 1 then default,axiscolor,0 else default,axiscolor,1
;if keyword_set(aia) then docont=0. else default,docont,0
default,docont,0
default,nocontcolor,0
default,noclabel,0
default,nlev,11
default,winnumber,!d.window>0
if ngrid ne 0 then default,nwinx,ngrid else default,nwinx,750
if ngrid ne 0 then default,nwiny,ngrid else default,nwinx,750
default,whitedisk,-1

default,nulldatacolor,''
default,sunedge,1.0
default,noerase,0
default, title, ''
default, extratitle, ''
default, moreplots,0
default, stklines, 0
default, nstarrow, 50
default,arrowave,1


end
