;---------------------------------------------------------------------
;
;                         FOR_ARWEIGHT.pro
;
;----------------------------------------------------------------------
;
; Purpose:
;
; This function implements bright patches mimicking Active Regions
;
; Called by FOR_UV_STOKES
;
; CALLING SEQUENCE:
;    for_arweight(chromoheight, theta3d_chromo, phi3d_chromo, chromo_thmin, chromo_thmax, chromo_phmin, chromo_phmax,chromopatch)
;
; INPUTS:
;   chromoheight = radial position or height 
;    of the footpoints of the cone drawn from the scattering point P
;
;   theta3d_chromo = polar angle of the cone footpoints 
;     in global spherical MODEL coordinates
;
;   phi3d_chromo = azimuthal angle of the cone footpoints
;     in global spherical MODEL coordinates
;
;  CHROMO_THMIN, CHROMO_THMAX, CHROMO_PHMIN, CHROMO_PHMAX, CHROMOPATCH
;   see FOR_OBSDEFAULTS for explanation
;
; OUTPUTS:
;   Array that is set to 1 everywhere except in patch defined by CHROMO_TH/PH-MIN/MAX
;		where it is set to CHROMOPATCH

function for_arweight,chromoheight,theta3d_chromo,phi3d_chromo,chromo_thmin,chromo_thmax,chromo_phmin,chromo_phmax,chromopatch

; unweighted by default
ARweight = theta3d_chromo*0.d0 + 1.d0 ;INTARR(100., 100.)

theta3d_chromo_deg = theta3d_chromo/!dtor
phi3d_chromo_deg = phi3d_chromo/!dtor

test_phi = where(phi3d_chromo_deg lt 0., ntp)
if ntp ne 0. then phi3d_chromo_deg[test_phi] = phi3d_chromo_deg[test_phi] + 360.

test_phi = where(phi3d_chromo_deg gt 360., ntp)
if ntp ne 0. then phi3d_chromo_deg[test_phi] = phi3d_chromo_deg[test_phi] - 360.

test=where(theta3d_chromo_deg gt chromo_thmin and theta3d_chromo_deg lt chromo_thmax and phi3d_chromo_deg gt chromo_phmin and phi3d_chromo_deg lt chromo_phmax, nt)

if nt ne 0 then ARweight[test]=chromopatch

;if nt ne 0 then begin
;	print,'patch'
;        print,'theta patch',minmax(theta3d_chromo_deg)
;	print,'phi patch',minmax(phi3d_chromo_deg)
;endif

return, ARweight

end
