pro for_iondens,ObsPramsStruct,ModSolStruct,ModPramsStruct,r3D,r,iondens,nochromoadd=nochromoadd,nowidgmess=nowidgmess

;+                   
; Name: FOR_IONDENS
;                
; Purpose:  calculate ion density from line information and
;	 	electron density
;                
; INPUT    
;           
;      ObsPramsStruct (with line info)
;	ModSolStruct (with density,temperature info for electron)
;	ModPramsStruct (for model name)
;	r3D (for test of transition region)
;	r (for adding chromodens only on disk)
;	  not needed when nochromoadd is set 
;      
;	Nowidgmess-- no widget text output
;	Nochromoadd-- dont add chromodens to disk
;	   NOT A GLOBAL KEYWORD
;	   only used when called by for_uvmodel and for_uv_densminmax
;	   in order to get a value of ion density
;	   without background added
;
; OUTPUT
;	Ion density
;
; Calls FOR_IDSET
; Called by FOR_POSNOINT,FOR_UVMODEL,FOR_UV_DENSMINMAX
;
; Oct 2023 -- added check for PSI threshold temperatures and ModPramsStruct pass through
;		changed below transition region points to NaNs
;		and passed through r3D and r 
;		and chromodens keyword to add chromodens 
; Feb 2024 -- fixed bug where testtrans could be -1
; Dec 2024 -- passed r through to for_idset
; July 2025 -- added nochromoadd
; August 2025 -- added notes and forced no chromo adding 
;		for POS and removed check for no chromo add
;		because for_idset takes care of it

logT=alog10(ModSolStruct.Temp)
Dens=ModSolStruct.Dens
posuse = ObsPramsStruct.Pos

for_idset,ObsPramsStruct,LogT,dens,r,iondens,chromodens,nowidgmess=nowidgmess,nochromoadd=nochromoadd

if strupcase(ModPramsStruct.name) eq 'PSIMAS' or strupcase(ModPramsStruct.name) eq 'AWSOM' then begin
;
; deal with overbroad transition region in PSI MAS Model
; points less than 500000K should be ignored
;  IN THE NEAR FIELD!!! not the far field
; we will accomplish this by setting density zero there
; note that chromodens will be added on the disk

  testtrans=where(ModSolStruct.Temp lt 5d5 and r3D lt 5.,c)
  if c ne 0 then begin
   iondens[testtrans]=0.
   if ObsPramsStruct.SpecPrams.ChromoRad lt 0. or keyword_set(nochromoadd) or posuse eq 1 then iondens[testtrans]=sqrt(-1.)
; create nans
  endif
endif

; NOTE NOCHROMOADD IS NOT A GLOBAL KEYWORD
; the global way to turn off chromorad as added to the
; disk is to change the sign of chromorad to negative
; which is easy in the widget but line command you need to
; look in for_specdefaults for the value and call for_drive with that
; with a negative sign.

; dont need to check because in for_idset we check and replace chromodens with ero
; anyway if we did it here, should also check for negative chromorad
;
;if keyword_set(nochromoadd) ne 1 and posuse ne 1 then begin
testdisk=where(r le 1,nr)
if nr ne 0 then iondens[testdisk]=iondens[testdisk]+chromodens
;endif

; RAVEENA -- to do eventually
; maybe move all the patch/psi thresholding here so iondens
; that comes out includes it, and then in for_uv_stokes forward calculate
; the chromorad from the iondens here 
;  BUT NOT C2L -- that is still done in for_uv_stokes

end
