C
C PURPOSE: SOLVES SE EQUATIONS
C
C INPUTS: NDIM, A, B
C
C OUTPUTS:
C
C COMMON:
C
C COMMENTS: OCTOBER 6, 1999, P. JUDGE
C 
      SUBROUTINE SOLVE(NDIM,A,B)
C
      INCLUDE 'PREC'
      INCLUDE 'PARAM'
      INCLUDE 'CSE'
      INCLUDE 'CINPUT'
      INCLUDE 'CINTS'
      INCLUDE 'CLU'
C
      DIMENSION A(NDIM,NDIM),B(NDIM)
      LOGICAL NEW
      DATA NEW /.TRUE./
C     
C  COPY SCOEFF ARRAY TO ARRAY A
C
C      CALL CPTIME('SOLVE ',0,0,1)
      DO I=1,NDIM
         DO J=1,NDIM
            A(I,J)=SCOEFF(I,J)
         END DO
         B(I)=ZERO
      END DO
C
C  PARTICLE NUMBER DENSITY CONSERVATION
C
      DO I=1,NDIM
         A(ISUM,I)=WEIGHT(I)
      END DO
C      
      B(ISUM)=ONE
C
      CALL EQSYST(NDIM,NDIM,A,B,NEW)
C
C	WRITE (LOUT,10) 'ACCURACY OF SOLUTION:'
C10	FORMAT(/A)
C
C      DO I=1,NDIM
C         TMP=.0
C         DO J=1,NDIM
C            TMP=SCOEFF(I,J)*B(J)+TMP
C         END DO
C	  WRITE (LOUT,20) I,TMP
C 20      FORMAT(1X,I3,1X,1P,E10.3)
C      END DO
C      CALL CPTIME('SOLVE ',0,1,1)

      RETURN
      END
