C
C PURPOSE: COPIES SOLUTION OF S.E. EQUATIONS INTO THE DENSITY-MATRIX VECTOR
C
C INPUTS:
C       NDIM
C       SOL
C OUTPUTS:
C       RHO (SET IN COMMON CSE)
C COMMON:
C       CATOM CSE CLU
C COMMENTS: OCTOBER 6, 1999, P. JUDGE
C 
	SUBROUTINE SE0_COPY(NDIM,SOL)
	INCLUDE 'PREC'
	INCLUDE 'PARAM'
	INCLUDE 'CATOM'
	INCLUDE 'CSE'
	INCLUDE 'CINTS'
	INCLUDE 'CINPUT'
	INCLUDE 'CLU'
C
	DIMENSION RHONORM(0:MJTOT,0:MJTOT)
	DIMENSION SOL(NDIM)
C
	I=0
	TRACE=ZERO
C debug statement updated 6jul22
        IF(IDEBUG.EQ.1) THEN
	   WRITE(LOUT,*)'NORMALIZED DENSITY MATRIX VECTOR, RHO(J,K)'
	   WRITE(LOUT,21) 'K=',(K,K=0,INT(2*AJ(NK)),2)
	ENDIF

	DO IJ=1,NK
	   I2J=NINT(TWO*AJ(IJ))
C Note stepping by 2 added with 6jul22 version
	   DO K=0,I2J,2
	      I=I+1
	      IF (K.EQ.0) WGT=WEIGHT(I)
	      RHO(IJ,K)=SOL(I)
	      RHONORM(IJ,K)=WGT*SOL(I)
	  END DO
	  TRACE=RHONORM(IJ,0)+TRACE
C outputting by 2 added 6jul22
	  IF(IDEBUG.EQ.1) WRITE (LOUT,20)'J=',IJ,(RHONORM(IJ,K),K=0,I2J,2)
	END DO
       IF(IDEBUG.EQ.1) THEN 
	  WRITE(LOUT,30) ' TRACE =',TRACE
	  WRITE(LOUT,10) ' ALIGNMENT FACTOR, RHO(J,2)/RHO(J,0)'
	  DO IJ=1,NK
	     WRITE (LOUT,40) ' J =',IJ,RHO(IJ,2)/RHO(IJ,0)
	  END DO
	ENDIF
 10	FORMAT(/A/)
 20	FORMAT(2X,1P,A,I3,1X,12(1X,E10.3))
C next format statement added 6jul22
 21     FORMAT(1X,A,12(1X,I10))
 30	FORMAT(/2X,1P,A,E10.3)
 40	FORMAT(2X,1P,A,I3,2X,E10.3)
	RETURN
	END
