C
C PURPOSE: COMPUTE RADIATIVE RATES R(6) FOR EQN (20) OF 
C          CASINI, R. & JUDGE, P. G., 1999. AP J 522, 524-539
C          THE COMPLETE COEFFICIENT NEEDED FOR EQ. (20) IS 
C          BUILT BY SUMMING OUTSIDE OF THIS ROUTINE IN ROUTINE
C          SE0_BUILD
C
C INPUTS:
C       
C OUTPUTS:
C       R6COEFF
C COMMON:
C
C COMMENTS: OCTOBER 6, 1999, P. JUDGE
C 
	SUBROUTINE R6(NJ,IJ,K,K1,IQ,R6COEFF)
C  THIS SUBROUTINE CALCULATES THE RADIATIVE RATES R(6)
C
C  THE RADIATION FIELD IS ASSUMED TO BE CYLINDRICALLY
C  SYMMETRIC IN THE REFERENCE FRAME IN WHICH THE S.E.
C  EQUATIONS ARE EXPRESSED.
	INCLUDE 'PREC'
	INCLUDE 'PARAM'
	INCLUDE 'CSE'
	INCLUDE 'CATOM'
	INCLUDE 'SGNM'
	INCLUDE 'CINTS'
	RJ=AJ(IJ)
	RK=FLOAT(K)
	RK1=FLOAT(K1)
	Q=FLOAT(IQ)
	R6TMP=ZERO
C Note - this next line from 6jul22 version-- should it be kept?
	DO K2=0,2,2 !PGJ TEST
	  IF(SG(K+K1+K2).GT.ZERO) THEN		! \ZETA+ = 1
	    RK2=FLOAT(K2)
	    R6TMP1=ZERO
	    DO IJ1=IJ+1,NJ
		KR=KRAD(IJ,IJ1)
		IF(KR.NE.0) THEN
	        RJ1=AJ(IJ1)
	        R6TMP1=SG(NINT(RJ-RJ1))*ECOEFF(IJ,IJ1)
     /	         *FUN6J(ONE,ONE,RK2,RJ,RJ,RJ1)
     /               *RADJ(K2,KR)+R6TMP1
		END IF
	    END DO
	    R6TMP=SQRT(TWO*RK2+ONE)
     /	    *FUN3J(RK,RK1,RK2,Q,-Q,ZERO)
     /	    *FUN6J(RK,RK1,RK2,RJ,RJ,RJ)*R6TMP1+R6TMP
	  END IF
	END DO
	R6COEFF=SG(K+K1-IQ+1)
     /	  * SQRT(THREE*(TWO*RK+ONE)*(TWO*RK1+ONE))
     /	  * (TWO*RJ+ONE)*R6TMP
	RETURN
	END
