C
C PURPOSE: COMPUTE SUPERELASTIC MULTIPOLAR COLLISIONAL RATE
C
C INPUTS:
C       IL    LOWER LEVEL INDEX
C       I     UPPER LEVEL INDEX
C       K     MULTIPOLAR INDEX
C OUTPUTS:
C       GAMMAS
C COMMON:
C       CATOM CLU
C RESTRICTIONS:  THE TOTAL COLLISIONAL RATES C(I,J) ARE ASSUMED
C       TO BE THE RESULT OF 1 MULTIPOLE COMPONENT.  THIS MAY NOT BE 
C       CONSISTENT WITH THE INPUT DATA. SEE THE README FILE WITH THIS PROGRAM. 
C
C COMMENTS: OCTOBER 6, 1999, P. JUDGE
C EDITED: JUNE 6 2019 P. JUDGE
C   INTEGER DO-LOOP VARIABLES
C   FIXED ERRONEOUS DENOMINATOR IN GAMMAS
C   SEE COMMENTS IN GAMMAI.F
C ---Sept 2022 replaced pre 6jul22 version
C	
	FUNCTION GAMMAS(IL,I,K)
	INCLUDE 'PREC'
	INCLUDE 'PARAM'
	INCLUDE 'CSE'
	INCLUDE 'CLU'
	INCLUDE 'CATMOS'
	INCLUDE 'CATOM'
	INCLUDE 'CINPUT'
	INCLUDE 'CINTS'
	GAMMAS=ZERO
	IF(ICOLL .EQ. 0 .OR. I.LE.IL) RETURN
C
	IF(ITTYPE(I,IL) .EQ. 1 .AND. K .EQ. 1) GAMMAS=C(IL,I)
	IF(ITTYPE(I,IL) .EQ. 2 .AND. K .EQ. 2) GAMMAS=C(IL,I)
C
	FJL=AJ(IL) 
	FJ=AJ(I)
	FK=FLOAT(K)
C
C       DIVIDE BY FINAL STATE 2J+1
C	TO CONSERVE PROBABILITY
C
	CASSUME=ZERO
	IF((ITTYPE(I,IL) .LT. 0 .OR. ITTYPE(I,IL) .GE. 3)
     *     .AND. ICOLL .NE. 2) 
     *    CASSUME=C(IL,I)/G(IL)
C
C SKIP FURTHER CALCULATIONS IF NO MORE COLLISIONS ARE TO BE ADDED
C	
	IF(CASSUME .EQ. ZERO .AND. ICOLLMM .EQ. 0) RETURN
C
C  CMM FORMALISM, EQUATION AT MIDDLE OF P 802 OF LANDI AND LANDOLFI
C  
	NLO=INT(G(IL)-ONE)
	NUP=INT(G(I)-ONE)
	DO NL=-NLO,NLO,2
	   AL=FLOAT(NL)/2.
	   DO NU=-NUP,NUP,2
	      AU=FLOAT(NU)/2.
	      DO M=0,K
		 P=FLOAT(M)
		 F3=FUN3J(FJL,FJ,FK,-AL,AU,P)
c 		 write(*,*) 'gammas ',K, M,F3 
		 GAMMAS=GAMMAS + (CMM(IL,I,NL/2,NU/2)+CASSUME)*F3*F3*
     *                    (TWO*FK+ONE)/G(I)
	      ENDDO
	   ENDDO
	ENDDO
	IF(IDEBUG .NE. 0 .AND. GAMMAS .NE. 0.) THEN 
	   WRITE(LOUT,*)'ITTYPE  CASSUME ',ITTYPE(I,IL),CASSUME
           WRITE(LOUT,*)
     *     'GAMMAS IL,I, K, F3, C(IL,I) ',GAMMAS, IL, I, K, F3, C(IL,I)
	ENDIF
	RETURN
	END



