C
C PURPOSE: COMPUTES INELASTIC COLLISION RATES 
C          FROM THE 
C INPUTS:
C          IJ       INDEX OF LOWER LEVEL 
C          IJ1      INDEX OF UPPER LEVEL
C          K        MULTIPOLAR COEFFICIENT
C
C OUTPUTS:
C          CS       SUPERELASTIC RATE FROM MULTIPOLAR COMPONENT K
C COMMON:
C
C COMMENTS: OCTOBER 6, 1999, P. JUDGE
C 
	FUNCTION CS(IJ,IJ1,K)
C  THIS FUNCTION CALCULATES THE INELASTIC COLLISIONAL RATES 
C  C_S(IJ,IJ1,K) (FOR IJ1 > IJ)
	INCLUDE 'PREC'
	INCLUDE 'PARAM'
	INCLUDE 'CSE'
	INCLUDE 'SGNM'
	INCLUDE 'CINTS'
	RJ=AJ(IJ)
	RJ1=AJ(IJ1)
	RK=FLOAT(K)
	JP=NINT(RJ+RJ1)
	JM=NINT(ABS(RJ-RJ1))
	CSTMP=ZERO
	DO K1=JM,JP
	  RK1=FLOAT(K1)
     	  CSTMP=SG(K1)*FUN6J(RJ,RJ,RK,RJ1,RJ1,RK1)*GAMMAS(IJ,IJ1,K1)
     /	  +CSTMP
	END DO
	CS=SG(JP-K)*SQRT((TWO*RJ+ONE)*(TWO*RJ1+ONE))*CSTMP
	RETURN
	END
