C
C PURPOSE: CONVERTS VACUUM LAMBDA TO AIR (.GT.2000 A)
C
C INPUTS:
C
C OUTPUTS:
C
C COMMON:
C     NONE
C COMMENTS: OCTOBER 6, 1999, P. JUDGE
C 
      FUNCTION CONVL(ALAMB)
C
C  CONVERTS VACUUM LAMBDA TO AIR (.GT.2000 A) OR VACUUM
C  (.LT.2000 A) LAMBDA
C  CONSTANTS FROM STARLINK PROGRAM IUEDR
C
      INCLUDE 'PREC'
      IF(ALAMB.LT.2000.) THEN
        CONVL=ALAMB
      ELSE
        CONVL=ALAMB/(1.0+2.735182E-4+131.4182/ALAMB/ALAMB+
     *   2.76249E8/ALAMB/ALAMB/ALAMB/ALAMB)
      ENDIF
C
      RETURN
      END
C
C**********************************************************************
C
