C
C PURPOSE: COMPUTE ELASTIC COLLISION RATES CE FOR EQN (20) OF 
C          CASINI, R. & JUDGE, P. G., 1999. AP J 522, 524-539
C          THE COMPLETE COEFFICIENT NEEDED FOR EQ. (20) IS 
C          BUILT BY SUMMING OUTSIDE OF THIS ROUTINE IN ROUTINE
C          SE0_BUILD
C INPUTS:
C          IJ       INDEX OF LEVEL.  
C          K        MULTIPOLAR COEFFICIENT
C OUTPUTS:
C          CE 
C COMMON:
C          CSE, SGNM
C COMMENTS: OCTOBER 6, 1999, P. JUDGE
C 
	FUNCTION CE(IJ,K)
C  THIS FUNCTION CALCULATES THE ELASTIC COLLISIONAL RATES C_E(IJ,K)
	INCLUDE 'PREC'
	INCLUDE 'PARAM'
	INCLUDE 'CSE'
	INCLUDE 'SGNM'
	INCLUDE 'CINTS'
C
	RJ=AJ(IJ)
	RK=FLOAT(K)
	JJ=2*NINT(RJ)
	CETMP=ZERO
C  note the step by 2 was added in Phil's 6jul22 version
	DO K1=0,JJ,2
	  RK1=FLOAT(K1)
     	  CETMP=SG(K1)*FUN6J(RJ,RJ,RK,RJ,RJ,RK1)*GAMMAE(IJ,K1)
     /	  +CETMP
	END DO
	CE=SG(JJ-K)*(FLOAT(JJ)+ONE)*CETMP
	RETURN
	END
