C
C PURPOSE: WRITES FREQUENCY QUADRATURE TO OUTPUT LISTING
C
C INPUTS:
C
C OUTPUTS:
C
C COMMON:
C
C COMMENTS: OCTOBER 6, 1999, P. JUDGE
C 
      SUBROUTINE WFREQ
C
C  
C
      INCLUDE 'PREC'
      INCLUDE 'PARAM'
      INCLUDE 'CATOM'
      INCLUDE 'CSLINE'
      INCLUDE 'CINPUT'
      INCLUDE 'CLU'
C
      IF(IWLINE.EQ.0) RETURN
C
      DO 10 KR=1,NLINE
         J=JRAD(KR)
         I=IRAD(KR)
         WRITE(LOUT,100) CONVL(ALAMB(KR)),J,I,LABEL(J),LABEL(I),
     *        Q(NQ(KR),KR)
 100     FORMAT(///'  LINE CENTER, LAMBDA=',F10.3,8X,I2,'-',I2,' (',
     *        A,'-',A,')',8X,'LINE WING, NY=',F10.3)
         WRITE(LOUT,310)
 310     FORMAT(//'  FREQUENCY QUADRATURE')
         DO 330 M=1,NQ(KR),10
            NYMAX=MIN(NQ(KR),M+9)
            WRITE(LOUT,320) (Q(NY,KR),NY=M,NYMAX)
            WRITE(LOUT,325) (DLAMB(Q(NY,KR),KR),NY=M,NYMAX)
 320        FORMAT(/9X,'Q',1P,10E11.3)
 325        FORMAT('  ANGSTROM',1P,10E11.3)
 330     CONTINUE
 10   CONTINUE
C     
      RETURN
      END
