C
C PURPOSE: CALCULATES THE (COMPLEX) SPHERICAL COMPONENTS OF GEOMETRIC TENSOR 
C       T_0^K(I) IN THE B-FRAME, FOR K=0,1,2
C
C INPUTS: T0
C
C OUTPUTS:
C
C COMMON:
C
C COMMENTS: OCTOBER 6, 1999, P. JUDGE
C           EQUATION NUMBERS REFER TO 
C           CASINI, R. & JUDGE, P. G., 1999. AP J 522, 524-539
C 
	SUBROUTINE T0TENS(T0)
C
	INCLUDE 'PREC'
	INCLUDE 'PARAM'
	INCLUDE 'CORON'
	INCLUDE 'CCONST'
	INCLUDE 'SGNM'
	INCLUDE 'CINTS'
	INCLUDE 'CLU'
C
	DIMENSION T0(0:3,0:2)
	PARAMETER (SQRT2=.14142135623730950488E1)
	PARAMETER (SQRT3=.17320508075688772935E1)
	STH=SIN(THETA)
	CTH=COS(THETA)
	S2G=SIN(TWO*PGAMMA)
	C2G=COS(TWO*PGAMMA)
	STHB=SIN(THETAB)
	CTHB=COS(THETAB)
	SPHB=SIN(PHIB)
	CPHB=COS(PHIB)
C
C  EQ. (42)
C
	COSF=CTH*CTHB+STH*STHB*CPHB
C
C  EQ. (44)
C
	SINCOSF=STH*CTHB-CTH*STHB*CPHB
C
C   CALCULATE  T0(I,K)
C   THESE ARE ALL FROM TABLE 1 OF CASINI & JUDGE, WITH 
C   APPROPRIATE SUBSTITUTIONS 
C
	DO K=0,2
	   DO I=0,3
	      T0(I,K)=ZERO
	   END DO
	END DO
C
C   K=0
C
	T0(0,0)=ONE
C
C   K=1
C
	T0(3,1)=(SQRT3/SQRT2)*COSF
C
C   K=2
C
	T0(0,2)=(0.5/SQRT2)*(THREE*COSF*COSF-ONE)
	TMP1=-(THREE/SQRT2)*(STHB*STHB*SPHB*SPHB
     *				    -0.5*(ONE-COSF*COSF))
	TMP2=-(THREE/SQRT2)*STHB*SPHB*SINCOSF
	T0(1,2)=TMP1*C2G+TMP2*S2G
	T0(2,2)=-TMP1*S2G+TMP2*C2G
C	WRITE(LOUT,1000) 'T0 TENSOR (I,K)'
C	DO I=0,3
C	   WRITE(LOUT,'(1P,3(1X,E10.3))') (T0(I,K),K=0,2)
C	END DO
C1000	FORMAT(/A)
	RETURN
	END
