      SUBROUTINE RINPUT
C
C  READS AN INPUT FILE CONSISTING OF VARIABLE NAMES AND VALUES
C  THE VARIABLE NAMES AND VALUES MUST OCCUR IN PAIRS:
C  NAME, VALUE, NAME, VALUE, ETC.
C  IERR IS INITIALIZED TO 0.
C  IF A VARIABLE IN THE LIST IS NOT GIVE A VALUE IN THE INPUT FILE,
C  A WARNING IS ISSUED AND IERR IS SET TO 2.
C  IF A VARIABLE IN THE INPUT FILE IS NOT IN THE LIST
C  A WARNING IS ISSUED AND IERR IS SET TO 1.
C  IF IERR IS 2 AFTER THE READ OPERATION, STOP IS CALLED
C
C  LIST OF LOCAL VARIABLES:
C  MAVAR  NUMBER OF REAL-TYPE VARIABLES IN THE VARIABLE LIST
C  MIVAR  NUMBER OF INTEGER TYPE VARIABLES IN THE LIST
C  MCVAR  NUMBER OF CHARACTER TYPE VARIABLES IN THE LIST
C  VNAME  ARRAY CONTAINING THE VARIABLE NAMES
C  CVALUE CHARACTER ARRAY WHERE THE VARIABLE VALUES ARE PUT AT INPUT
C  INDV   = 1 FOR VARIABLE NAMES
C         =-1 FOR VARIABLE VALUES
C
C  IF THE INPUT LIST IS CHANGED, CHANGES HAVE TO BE MADE THREE PLACES:
C  PARAMETER (MAVAR=,MIVAR=)
C  DATA VNAME/.../
C  READ(LDUMI,*)
C
C  THE ORDER OF VARIABLES MUST BE THE SAME IN DATA VNAME AND IN
C  READ(LDUMI,*).
C
C  IN ADDITION THE OUTPUT LIST SHOULD BE CHANGED IN WINPUT
C  AND RELEVANT COMMON BLOCKS SHOULD BE CHANGED
C
      INCLUDE 'PREC'
      INCLUDE 'PARAM'
      INCLUDE 'CATOM'
      INCLUDE 'CSLINE'
      INCLUDE 'CINPUT'
      INCLUDE 'CLU'
C
      PARAMETER (MAVAR=6,MIVAR=8,MCVAR=1)
      CHARACTER*20 CVALUE(MAVAR+MIVAR+MCVAR)
      CHARACTER*80 TEXT
      CHARACTER VNAME(MAVAR+MIVAR+MCVAR)*6
      CHARACTER VDESCR(MAVAR+MIVAR+MCVAR)*45
      DATA VNAME/'TP2TE ','WLMIN ','WLMAX ','SMALLN','QNORM ','CECOEF',
     *  'ISUM  ','ICOLL ','ISPLIN',
     *  'IWATOM','IWLINE','IWEQI ','IDEBUG',
     *  'IWATMO','CRTN  '/
      DATA VDESCR/'RATIO OF PROTON TO ELECTRON TEMPERATURES     ',
     *            'SHORTEST WAVELENGTH OUTPUT TO FILE           ',
     *            'LONGEST  WAVELENGTH OUTPUT TO FILE           ',
     *            'CALCN IS SKIPPED FOR ELECT. DENS. < THIS     ',
     *            'NORMALIZATION FOR FREQUENCIES [KM/S]         ',
     *            'RATE COEFFICIENT FOR ELASTIC COLLISIONS      ',
     *            'LEVEL INDEX TO USE FOR CONSERVATION EQN.     ',
     *            'INCLUDE COLLISIONS                           ',
     *            'INTERPOLATION: 2=LINEAR, 3....N= SPLINE      ',
     *            'OUTPUT ATOMIC PARAMETERS TO FILE             ',
     *            'OUTPUT FREQUENCY DEPENDENT LINE DATA TO FILE ',
     *            'OUTPUT IONIZATION EQUILIBRIUM DATA           ',
     *            'OUTPUT DEBUGGING INFO.                       ',
     *            'OUTPUT CORONAL DATA TO FILE  ''ATMOS''       ',
     *            'NAME OF ROUTINE SUPPLYING MAGNETIC DATA      '/
C
      IERR=0
      INDV=-1
      DO 50 I=1,MAVAR+MIVAR+MCVAR
        CVALUE(I)=' '
   50 CONTINUE
C
C  GO THROUGH THE INPUT FILE LINE BY LINE
C
      CALL CSTRIP(LINPUT,'INPUT')
  100 CONTINUE
        K0=1
        READ(LDUMS,200,END=700) TEXT
  200   FORMAT(A)
C
C  SEARCH LINE WORD BY WORD. EVERY SECOND WORD IS CONSIDERED TO BE
C  A VARIABLE NAME, EVERY SECOND ITS VALUE.
C  = IS IGNORED. K1=0 IN GETWRD IS A FLAG THAT THERE ARE NO MORE WORDS
C  ON THE LINE
C
  300   CONTINUE
          CALL GETWRD(TEXT,K0,K1,K2)
          IF(K1.EQ.0) GOTO 600
          K0=K2+2
          IF(TEXT(K1:K2).EQ.'=') GOTO 300
          INDV=-INDV
          IF(INDV.EQ.1) THEN
C
C  INDV=1 : VARIABLE NAME
C
            DO 400 I=1,MAVAR+MIVAR+MCVAR
              IF(TEXT(K1:K2).EQ.VNAME(I)(1:K2-K1+1)) GOTO 500
  400       CONTINUE
C
C  INPUT VARIABLE IS NOT IN LIST, OUTPUT WARNING AND SKIP THE
C  FOLLOWING STRING (SUPPOSED TO BE THE VALUE OF THE VARIABLE)
C
            IERR=1
            WRITE(LJOBLO,420) TEXT(K1:K2)
  420       FORMAT(4X,A,' IS NOT IN LIST')
            CALL GETWRD(TEXT,K0,K1,K2)
            IF(K1.EQ.0) THEN
              K0=1
  450         READ(LDUMS,200,END=700) TEXT
              CALL GETWRD(TEXT,K0,K1,K2)
              IF(K1.EQ.0) GOTO 450
            ENDIF
            K0=K2+2
            INDV=-INDV
            GOTO 300
C
C  INPUT VARIABLE IS IN LIST
C
  500       CONTINUE
            IVAR=I
          ELSE
C
C  INDV = -1 : VARIABLE VALUE
C
            CVALUE(IVAR)(20-K2+K1:20)=TEXT(K1:K2)
          ENDIF
        GOTO 300
  600   CONTINUE
      GOTO 100
  700 CONTINUE
C
C  ASSOCIATE VALUE TO VARIABLE
C  FIRST WRITE VALUES TO FILE, THEN READ VALUES IN FREE FORMAT
C  OUTPUT WARNING IF NO VALUE EXISTS
C
      CALL OPEN(LDUMI,'DUMI',1,'UNKNOWN')
      DO 740 I=1,MAVAR+MIVAR+MCVAR
        IF(CVALUE(I).EQ.' ') THEN
          IERR=2
          WRITE(LJOBLO,710) VNAME(I)
  710     FORMAT(4X,A,' HAS NO VALUE')
        ENDIF
        WRITE(LDUMI,720) CVALUE(I)
  720   FORMAT(1X,A)
  740 CONTINUE
      IF(IERR.LE.1) THEN
        CALL REWIND(LDUMI)
        READ(LDUMI,*) TP2TE,WLMIN,WLMAX,SMALLN,QNORM,CECOEF,
     *   ISUM,ICOLL,ISPLIN,IWATOM,IWLINE,IWEQI, 
     *   IDEBUG, IWATMO,CRTN
        CALL CLOSE(LDUMI)
      ELSE
        CALL STOP('RINPUT: IERR=2')
      ENDIF
C
      WRITE(LOUT,53) 
 53   FORMAT('1 INPUT PARAMETERS  '//)
      DO I=1, MAVAR+MIVAR+MCVAR
         WRITE(LOUT,54)VNAME(I),CVALUE(I),VDESCR(I)
 54      FORMAT(A,1X,A,3X,A)
      ENDDO
      WRITE(LOUT,55) 
 55   FORMAT(//)
C     
      RETURN
      END
C
C**********************************************************************
C
