C
C PURPOSE: COMPUTE RADIATIVE RATES R(2) FOR EQN (20) OF 
C          CASINI, R. & JUDGE, P. G., 1999. AP J 522, 524-539
C          THE COMPLETE COEFFICIENT NEEDED FOR EQ. (20) IS 
C          BUILT BY SUMMING OUTSIDE OF THIS ROUTINE IN ROUTINE
C          SE0_BUILD
C
C INPUTS:
C       IJ
C OUTPUTS:
C       R2COEFF
C COMMON:
C
C COMMENTS: OCTOBER 6, 1999, P. JUDGE
C 
	SUBROUTINE R2(IJ,K,K1,IQ,R2COEFF)
C  THIS SUBROUTINE CALCULATES THE RADIATIVE RATES R(2).
C
C  THE RADIATION FIELD IS ASSUMED TO BE CYLINDRICALLY
C  SYMMETRIC IN THE REFERENCE FRAME IN WHICH THE S.E.
C  EQUATIONS ARE EXPRESSED.
	INCLUDE 'PREC'
	INCLUDE 'PARAM'
	INCLUDE 'CSE'
	INCLUDE 'CATOM'
	INCLUDE 'SGNM'
	INCLUDE 'CINTS'
	RJ=AJ(IJ)
	RK=FLOAT(K)
	RK1=FLOAT(K1)
	Q=FLOAT(IQ)
	R2TMP=ZERO
C Note - this next line from 6jul22 version-- should it be kept?
	DO K2=0,2,2 !PGJ TEST
	  IF(SG(K+K1+K2).GT. ZERO) THEN			! \ZETA+ = 1
	    RK2=FLOAT(K2)
	    R2TMP1=ZERO
	    DO IJ1=1,IJ-1
		KR=KRAD(IJ,IJ1)
		IF(KR.NE.0) THEN
	        RJ1=AJ(IJ1)
	        R2TMP1=SG(NINT(RJ-RJ1))
     /	         *(TWO*RJ1+1.0)*ECOEFF(IJ1,IJ)
     /	         *FUN6J(ONE,ONE,RK2,RJ,RJ,RJ1)
     /               *RADJ(K2,KR)+R2TMP1
		END IF
	    END DO
	    R2TMP=SQRT(TWO*RK2+ONE)
     /	    *FUN3J(RK,RK1,RK2,Q,-Q,ZERO)
     /	    *FUN6J(RK,RK1,RK2,RJ,RJ,RJ)*R2TMP1+R2TMP
	  END IF
	END DO
	R2COEFF=SG(-IQ+1)*SQRT(THREE*(TWO*RK+ONE)*(TWO*RK1+ONE))
     /	  *R2TMP
	RETURN
	END
