C
C PURPOSE: CALCULATES LTE POPULATIONS
C
C INPUTS:
C
C OUTPUTS:
C
C COMMON:
C     CATOM CATMOS CCONST CLU
C COMMENTS: OCTOBER 6, 1999, P. JUDGE
C 
      SUBROUTINE LTEPOP
C
C  CALCULATES LTE POPULATIONS
C:
C: LTEPOP 87-04-07  MODIFICATIONS: (PHILIP JUDGE)
C:        A DANGER SIGN IS OUTPUT WHEN ZERO POPULATIONS ARE FOUND.
C:
C:        88-02-01  MODIFICATIONS: (MATS CARLSSON)
C:        PROVISION FOR MOLECULES ADDED
C:
C:        88-07-01  MODIFICATIONS: (MATS CARLSSON)
C:        DEBYE LOWERING OF IONIZATION POTENTIAL TAKEN INTO ACCOUNT
C:
C:        92-03-19  MODIFICATIONS: (PHILIP JUDGE)
C:        ZERO SET TO 0. INSTEAD OF 1.E-37 IN DANGER CHECK
C:        
C:        00-08-10  MODIFICATIONS: (PHILIP JUDGE)
C:        REMOVED MOLECULAR PROVISION
C:        
      INCLUDE 'PREC'
      INCLUDE 'PARAM'
      INCLUDE 'CATOM'
      INCLUDE 'CATMOS'
      INCLUDE 'CCONST'
      INCLUDE 'CLU'
C
      DIMENSION TNS(MK),NDXI(20)
C*
C* 88-07-01 MATS CARLSSON
C* THE ENERGIES OF IONIZATION ARE REDUCED BY ION*DXI, FOLLOWING BASCHEK ET
C* AL., ABH. HAMB. VIII, 26 EQ. (10). 
C* SINCE ALL EV REFERS TO THE LOWEST LEVEL, IT IS NECESSARY TO SUBTRACT
C* FROM THE ENERGY OF A LEVEL ALL DXI EXPERIENCED BY LOWER IONIZATION
C* STAGES. THIS NUMBER IS STORED IN NDXI(ION)
C*
      NDXI(1)=0
      DO 50 I=2,20
        NDXI(I)=NDXI(I-1)+(I-1)
   50 CONTINUE
      DO 60 I=1,20
        NDXI(I)=NDXI(I)-NDXI(ION(1))
   60 CONTINUE
C
      CCON=0.5*(HH/SQRT(2.*PI*EM)/SQRT(BK))**3
      T=TEMP
      CONL=LOG(CCON*ED)-1.5*LOG(T)
      DXI=4.98E-4*5040./T*SQRT(ED*BK*T)
      SUMN=1.
      DO 300 I=2,NK
         EVI=EV(I)-DXI*NDXI(ION(I))
         TNSL=LOG(G(I))-LOG(G(1))-EK/T*EVI
         IF(ION(I).LE.ION(1)) GOTO 100
         L=ION(I)-ION(1)
         TNSL=TNSL-FLOAT(L)*CONL
 100     TNS(I)=EXP(TNSL)
         SUMN=SUMN+TNS(I)
 300  CONTINUE 
      PSTAR(1)=TOTN/SUMN
      DO 400 I=2,NK
         PSTAR(I)=TNS(I)*PSTAR(1)
         IF(PSTAR(I) .LE. 0.)WRITE(LJOBLO,1000)I
 1000    FORMAT(' LTEPOP: LEVEL ',I3,' HAS ZERO
     *        LTE POPULATION')
 400  CONTINUE
C      WRITE(LOUT,1003)(PSTAR(I),I=1,NK)
C      WRITE(LOUT,1004)(PSTAR(I)/TOTN,I=1,NK)
C 1003 FORMAT(1X/1X,'LTE POPULATIONS, ABSOLUTE, NORMALIZED'/1P,8(E10.3))
C 1004 FORMAT(1P,8(E10.3))
      RETURN
      END
