C
C PURPOSE: CALCULATES 9J VALUE
C
C INPUTS:
C       RJ11,RJ12,RJ13  REAL J QUANTUM NUMBERS IN 1ST ROW OF 9J
C       RJ21,RJ22,RJ23  REAL J QUANTUM NUMBERS IN 2ND ROW OF 9J
C       RJ31,RJ32,RJ33  REAL J QUANTUM NUMBERS IN 3RD ROW OF 9J
C
C OUTPUTS:
C       FUN9J 9J SYMBOL
C COMMON:
C
C COMMENTS: OCTOBER 6, 1999, P. JUDGE
C 
	FUNCTION FUN9J(RJ11,RJ12,RJ13,RJ21,RJ22,RJ23,RJ31,RJ32,RJ33)
	INCLUDE 'PREC'
	INCLUDE 'PARAM'
	INCLUDE 'SGNM'
	INCLUDE 'CINTS'
	IJ11=NINT(RJ11+RJ11)
	IJ12=NINT(RJ12+RJ12)
C	IJ13=NINT(RJ13+RJ13)
	IJ21=NINT(RJ21+RJ21)
C	IJ22=NINT(RJ22+RJ22)
	IJ23=NINT(RJ23+RJ23)
C	IJ31=NINT(RJ31+RJ31)
	IJ32=NINT(RJ32+RJ32)
	IJ33=NINT(RJ33+RJ33)
	KMIN1=IABS(IJ11-IJ33)
	KMIN2=IABS(IJ32-IJ21)
	KMIN3=IABS(IJ23-IJ12)
	IF(KMIN2.GT.KMIN1) KMIN1=KMIN2
	IF(KMIN3.GT.KMIN1) KMIN1=KMIN3
	KMAX1=IJ11+IJ33
	KMAX2=IJ32+IJ21
	KMAX3=IJ23+IJ12
	IF(KMAX2.LT.KMAX1) KMAX1=KMAX2
	IF(KMAX3.LT.KMAX1) KMAX1=KMAX3
	FUN9J=ZERO
	IF(KMIN1.LE.KMAX1) THEN
	  DO K=KMIN1,KMAX1,2
	    FK5=0.5*FLOAT(K)
	    FUN9J=FUN9J+SG(K)*FLOAT(K+1)
     /	    *FUN6J(RJ11,RJ21,RJ31,RJ32,RJ33,FK5)
     /	    *FUN6J(RJ12,RJ22,RJ32,RJ21,FK5,RJ23)
     /	    *FUN6J(RJ13,RJ23,RJ33,FK5,RJ11,RJ12)
	  END DO
	END IF
	RETURN
	END
