C
C PURPOSE: CALCULATES THE B-FRAME IRRED. TENSOR COMPONENTS OF AVG RADN FIELD
C          FROM THE PHOTOSPHERE IN THE "B" FRAME (SEE FIG 5 OF 
C          CASINI, R. & JUDGE, P. G., 1999. AP J 522, 524-539)
C INPUTS:
C
C OUTPUTS:
C
C COMMON:
C       CATOM CCONST CORON CSE
C COMMENTS: OCTOBER 6, 1999, P. JUDGE
C 
	SUBROUTINE FIELDB(KR)

C  THIS SUBROUTINE CALCULATES IRREDUCIBLE TENSOR COMPONENTS
C  OF THE AVERAGE RADIATION FIELD FROM THE PHOTOSPHERE IN THE B
C  FRAME

	INCLUDE 'PREC'
	INCLUDE 'PARAM'
	INCLUDE 'CATOM'
	INCLUDE 'CCONST'
	INCLUDE 'CORON'
	INCLUDE 'CSE'

	AMU_B=COS(THETAB)

	CALL FIELD_INT(KR,RADJ_0,RADJ_1,RADJ_2)

	RADJ(0,KR)=RADJ_0
	RADJ(1,KR)=RADJ_1
	RADJ(2,KR)=0.5*(3.0*AMU_B*AMU_B-1.0)*RADJ_2

	RETURN
	END
