C
C PURPOSE: CONVERT FROM DELTA LAMBDA IN Q UNITS TO DELTA LAMBDA IN ANGSTROM
C
C INPUTS:
C     QQ DELTA LAMBDA IN TYPICAL DOPPLER WIDTH UNITS
C     KR RADIATIVE TRANSITION INDEX
C
C OUTPUTS:
C     DLAMB
C COMMON:
C     CATOM CCONST
C COMMENTS: OCTOBER 6, 1999, P. JUDGE
C 
      FUNCTION DLAMB(QQ,KR)
      INCLUDE 'PREC'
      INCLUDE 'PARAM'
      INCLUDE 'CATOM'
      INCLUDE 'CCONST'
C
      QN=QNORM*1.E5/CC
      DLAMB=-ALAMB(KR)*QQ*QN/(1.0+QQ*QN)
      RETURN
      END
C
C************************************************************************
C
