C
C PURPOSE: COMPUTE COLLISION RATES C(3) FOR EQN (20) OF 
C          CASINI, R. & JUDGE, P. G., 1999. AP J 522, 524-539
C          THE COMPLETE COEFFICIENT NEEDED FOR EQ. (20) IS 
C          BUILT BY SUMMING OUTSIDE OF THIS ROUTINE IN ROUTINE
C          SE0_BUILD
C INPUTS:
C          IJ       INDEX OF LEVEL.  
C          IJ1      INDEX OF LOWER LEVEL
C          K        MULTIPOLAR COEFFICIENT
C OUTPUTS:
C          C3COEFF  
C COMMON:
C          CSE
C COMMENTS: OCTOBER 6, 1999, P. JUDGE
C 
	SUBROUTINE C3(IJ,IJ1,K,C3COEFF)
C  THIS SUBROUTINE CALCULATES THE COLLISIONAL RATES C(3)  (FOR IJ1 < IJ)
	INCLUDE 'PREC'
	INCLUDE 'PARAM'
	INCLUDE 'CSE'
	INCLUDE 'CINPUT'
	INCLUDE 'CLU'
	INCLUDE 'CINTS'
	RJ=AJ(IJ)
	RJ1=AJ(IJ1)
	C3COEFF=SQRT((TWO*RJ1+ONE)/(TWO*RJ+ONE))*CI(IJ,IJ1,K)
	IF(IDEBUG.NE.0)WRITE(lout,100)IJ,IJ1,K,C3COEFF
 100	format('C3(U,L,K)',3(I4,1x),1p,e9.2,0p)
	RETURN
	END
