C
C PURPOSE: GIVES THE CPU TIME FROM ONE CALL TO ANOTHER
C
C INPUTS:
C     TEXT     STRING TO BE PRINTED OUT   
C     ISTART   IF 0 ZERO THE CLOCK ON EXIT
C     IPRI     PRINT TEXT AND IPRI BLANK LINES BETWEEN THE TEXT
C     LEVEL    (BETWEEN 1 AND 5) IS AN INDEX KEEPING TRACK OF THE
C              TIME- UP TO 5 TIMES CAN BE STORED SIMULTANEOUSLY
C OUTPUTS:
C
C COMMON:
C
C COMMENTS: OCTOBER 6, 1999, P. JUDGE
C 
      SUBROUTINE CPTIME(TEXT,ISTART,IPRI,LEVEL)
C
C  GIVES THE CPU TIME FROM ONE CALL TO ANOTHER
C  IT CAN BE ACTIVATED ON UP TO 5 DIFFERENT LEVELS.
C  THE MEANINGS OF ISTART AND IPRI:
C  ISTART =  0   ZERO CLOCK ON EXIT
C  IPRI .GT. 1   WRITE TIME, IPRI-1 BLANK LINES BEFORE AND
C                AFTER PRINTOUT
C
      INCLUDE 'PREC'
      INCLUDE 'CLU'
C
      CHARACTER TEXT*6,FMT*31
      DIMENSION B(5)
      SAVE B
      DATA B/0.,0.,0.,0.,0./
C
      A=SECOND()
      CPT=A-B(LEVEL)
      IF(ISTART.EQ.0) B(LEVEL)=A
      IF(IPRI.GT.0) THEN
        DO 50 I=1,IPRI-1
          WRITE(LTIME,40)
   40     FORMAT(1X)
   50   CONTINUE
        WRITE(FMT,100) 6-LEVEL,LEVEL+2
  100   FORMAT('(',I2,'X,A6,',I2,'X,''CPU='',F10.5,'' S'')')
        WRITE(LTIME,FMT) TEXT,CPT
        DO 150 I=1,IPRI-1
          WRITE(LTIME,40)
  150   CONTINUE
      ENDIF
      RETURN
      END
