FUNCTION FOR_GAMMAS,IJ,IJ1,K
;
; PURPOSE: COMPUTE SUPERELASTIC MULTIPOLAR COLLISIONAL RATE
;
; INPUTS:
;       IJ    LOWER LEVEL INDEX
;       IJ1   UPPER LEVEL INDEX
;       K     MULTIPOLAR INDEX
; OUTPUTS:
;       GAMMAS
; RESTRICTIONS:  THE TOTAL COLLISIONAL RATES C(I,J) ARE ASSUMED
;       TO BE THE RESULT OF 1 MULTIPOLE COMP1.d0NT.  THIS MAY NOT BE 
;       CONSISTENT WITH THE INPUT DATA. SEE THE README FILE WITH THIS PROGRAM. 
;
; CALLED BY FOR_CS
; CALLS FOR_FUN3J
;
;	BUG FIX JUNE 2019 AA1 --> AA in CASSUME
;
@include.icle.input
@include.icle.cse
@include.icle.atom
@include.icle.thermal
GAMMAS=0.d0
IF(input.ICOLL  EQ  0 OR IJ1 LE IJ) then RETURN, gammas
;
IF(TTYPE(IJ1,IJ)  EQ  1  and  K  EQ  1) then GAMMAS=C(IJ1,IJ)
IF(TTYPE(IJ1,IJ)  EQ  2  and  K  EQ  2) then GAMMAS=C(IJ1,IJ)
;
;  CMM FORMALISM
;
; THIS IS THE EQUATION  AFTER EQ (A4.3) OF LANDI'S BOOK, FOR THE DIAGONAL CASE
; (N=N', N''=N''')
;'
AA=cse.AJ[IJ]
AA1=cse.AJ[IJ1]
FK=double(K)
;
; HERE WE ASSUME FOR SPIN-CHANGING AND STRONG COUPLING CASES
; THAT C(IJ1,IJ,N1,N) = C(IJ1,IJ)/(2*IJ1+1)
;
CASSUME=0.d0
IF(TTYPE(IJ1,IJ)  LE  0  and  input.ICOLL  NE  2) then CASSUME=C(IJ1,IJ)/(2.d0*AA+1.d0)
;
FOR  AN=-AA,AA do begin 
   FOR  AN1=-AA1,AA1 do begin 
      FOR  P=-FK,FK do begin 
         N=LONG(AN)
         N1=LONG(AN1)
         F3=FOR_FUN3J(AA,AA1,FK,-AN,AN1,P)
         GAMMAS+=(CMM(IJ1,IJ,N1,N)+CASSUME)*F3*F3*(2.d0*FK+1.d0)/(2.d0*AA1+1.d0)
      endfor 
   endfor 
endfor 
;if(IDEBUG  GE  0  and  GAMMAS  GE  0.) WRITE(LOUT,*)
;*     'GAMMAS IJ,IJ1, K ',GAMMAS, IJ, IJ1, K
;print,'GAMMAS IJ,IJ1, K ',GAMMAS, IJ, IJ1, K
RETURN,gammas
END



