pro for_save_plot,gif=gif,tiff=tiff,jpeg=jpeg,mapname=mapname,working_dir=working_dir,no_eight=no_eight
;+
;       NAME: FOR_SAVE_PLOT
;
;       This program saves the plots generated by for_plot and
;       (perhaps) for_plotbxy to output file
; 
;       Input Keywords:
;      
;       MAPNAME - name of plot file
;       GIF, TIFF JPEG-
;
; Called by FOR_DRIVE, FOR_PLOTFITS
;
; Written by Jim Dove, Terry Kucera, Sarah Gibson 2010-2014
; Version 2.0 July 2014
;-
; March 2016 - Added defaults for JPEG, GIF, TIFF SEG
; June 2019 - used slash for PC compatibility
;       Oct 2022 -- changed array ( to [ (with help from Vema Panditi)

slash=path_sep()

default,jpeg,0
default,gif,0
default,tiff,0

if n_elements(working_dir) eq 1 then begin
 if working_dir ne '' then saveplotname=working_dir+slash+mapname else saveplotname=mapname
endif else saveplotname=mapname 

;
;  WRITE TO FILES
;

tvlct,red,green,blue,/get

if jpeg eq 1 then begin
                                ;distinguish between screens with 
                                ;different numbers of bits.
      Device, Get_Visual_Depth=thisDepth 
      IF thisDepth GT 8 or keyword_set(no_eight) eq 1 THEN image = TVRD(/true) $
      ELSE begin
         image0 = tvrd()
         ISize = size(image)
         image = bytarr(3,ISize[1],ISize[2])
         image[0,*,*] = red[image0]
         image[1,*,*] = green[image0]
         image[2,*,*] = blue[image0]
      endelse
      write_jpeg,saveplotname+'.jpg',image,/true,quality=100
      cd,current=thedirectory
      print,'saved jpeg file '+saveplotname+'.jpeg from directory '+thedirectory
endif

if gif eq 1 then begin
      Device, Get_Visual_Depth=thisDepth
      IF thisDepth GT 8 or keyword_set(no_eight) eq 1 THEN begin
         image0=tvrd(/true)
         image=COLOR_QUAN(image0,1, R, G, B) 
         write_gif,saveplotname+'.gif',image,r,g,b
      endif $
      else write_gif,saveplotname+'.gif',tvrd(),red,green,blue 
      cd,current=thedirectory
      print,'saved gif file '+saveplotname+'.gif from directory '+thedirectory
endif

if tiff eq 1 then begin
      Device, Get_Visual_Depth=thisDepth
      IF thisDepth GT 8 or keyword_set(no_eight) eq 1 THEN begin
         image0 = TVRD(True=1) 				
         ISize=size(image0)
         image=bytarr(3,ISize[2],Isize[3])
         for i=0,2 do image[i,*,*]=reverse(rotate(reform(image0[i,*,*]),2))
         write_tiff,saveplotname+'.tif',image,xresol=600,yresol=600
      endif ELSE $ 	
         write_tiff,saveplotname+'.tif',reverse(rotate(tvrd(),2)),$
                    red=red,green=green,blue=blue,xresol=600,yresol=600
      cd,current=thedirectory
      print,'saved tiff file '+saveplotname+'.tif from directory '+thedirectory
endif

end
