;---------------------------------------------------------------------
;
;                      ALLEN_FUN_NE8.PRO
;
;---------------------------------------------------------------------
;
; Purpose
;
; This function computes the center-to-limb variation
;
; Called by FOR_UV_STOKES
;
; CALLING SEQUENCE:
;   allen_fun(mu)


function allen_fun_ne8, mu

; mu = cos(zeta)= sqrt(1.0 - rho^2) for far-away placed observer (Data from Withbroe 1970)
;x = [1.0, 0.99976474, 0.99905864, 0.9979742 , 0.99635446, 0.99394375, 0.99091767, 0.98632032, 0.98047375, 0.97489388, 0.96858056, 0.96193453, 0.95370301, 0.94560055, 0.93405087, 0.92487141, 0.91501933, 0.90446398, 0.89318973, 0.88115904, 0.86999531, 0.85820925, 0.84576852, 0.83072702, 0.81781585, 0.79558651, 0.77742148, 0.75184491, 0.73090427, 0.70571081, 0.67700328, 0.65096237, 0.62296464, 0.59078368, 0.55782291, 0.52174744, 0.48711112, 0.44890398, 0.41256095, 0.37188203, 0.33352855, 0.29414762, 0.26433837, 0.24222541, 0.21777052, 0.19038245, 0.13915936, 0.0483594]

; ne8_clv ratio from Withbroe 1970 Fig. 6
;y = [1.0, 1.0, 1.0, 1.0, 1.0, 1.03425, 1.03425, 1.03425, 1.03425, 1.03425, 1.03425, 1.06849, 1.10274, 1.13699, 1.13699, 1.13699, 1.17123, 1.20548, 1.27397, 1.30822, 1.41096, 1.41096, 1.47945, 1.47945, 1.54795, 1.58219, 1.68493, 1.78767, 1.89041, 1.99315, 2.09589, 2.16438, 2.30137, 2.43836, 2.64384, 2.81507, 3.02055, 3.29452, 3.53425, 3.91096, 4.32192, 4.73288, 5.17808, 5.55479, 6.0, 5.98384, 5.90301, 5.78986]


; Limb darkening equation from Allen's book is a 2-deg polynomial which has been used for FORCOMP/uv.f in case of visible spectropolarimetry
;I_by_I0 = 1. - u2 - v2 + (u2 * mu) + (v2 * mu^2) where mu=cos(theta)


; Limb darkening for white-light uses a simpler equation from Ch. 6 eq. 13 (Billings 1966) which is same as Allen if v2=0 which has been used in OBSERVABLES/for_cfun.pro and for_bfun.pro

; The fit below is specific to Ne VIII and requires a higher-order polynomial fit
; The variable ulimb will be used to scale this fit for the purposes of for e.g studying solar cycle effects and in general as a diagnostic tool for understanding the potential impact of symmetry breakigng

; The default choice of ulimb = 0 will turn off the center-to-limb variation effect.

a = -24.285
c0 = -36.981
c1 = 270.978
c2 = -1088.098
c3 = 2427.325
c4 = -2960.915
c5 = 1858.305
c6 = -469.629
;c7 = -607.981


I_by_I0 = a * alog10(mu) + c0 + (c1 * mu) + (c2 * mu^2) + (c3 * mu^3) + (c4 * mu^4) + (c5 * mu^5) + (c6 * mu^6)

;print, "7th deg polynomial", I_by_I0
return, I_by_I0

end
