C
C PURPOSE: CALCULATES LIMB DARKENING COEFFICIENTS
C
C INPUTS:
C       WL WAVELENGTH IN MICRONS
C OUTPUTS:
C       U,V COEFFICIENTS U2 AND V2 OF ALLEN (1973, P171)
C COMMON:
C
C RESTRICTIONS:
C       OUTSIDE OF WAVELENGTH RANGE EXTREME VALUES ARE USED.
C COMMENTS: JANUARY 11, 2006 P. JUDGE
C 
	SUBROUTINE UV(WL,U0,V0)
C
C  THIS FUNCTION CALCULATES ALLEN U AND V COEFFICIENTS FOR
C  LIMB DARKENING, SEE ALLEN (AQ 1973, SECTION 81)
C	
      INCLUDE 'PREC'
      INCLUDE 'PARAM'
      DIMENSION REFLAM(22),U(22),V(22)
C
      DATA REFLAM/.2,.22,.245,.265,.28,.30,.32,.35,.37,.38,
     /     .40,.45,.5,.55,.6,.8,1.,1.5,2.,3.,5.,10./
      DATA U/.12,-1.3,-.1,-.1,.38,.74,.88,.98,1.03,.92,
     /     .91,.99,.97,.93,.88,.73,.64,.57,.48,.35,.22,.15/
      DATA V/.33,1.6,.85,.9,.57,.2,.03,-.1,-.16,-.05,
     /     -.05,-.17,-.22,-.23,-.23,-.22,-.2,-.21,-.18,-.12,
     /     -.07,-.07/
C     
      IF (WL.LT.REFLAM(1)) THEN
         U0=U(1)
         V0=V(1)
         RETURN
      END IF
C     
      IF (WL.GT.REFLAM(22)) THEN
         U0=U(22)
         V0=V(22)
         RETURN
      END IF
      I=0
 1    I=I+1
      I1=I+1
      IF ((WL.GE.REFLAM(I)).AND.(WL.LT.REFLAM(I1))) THEN
         DL=(WL-REFLAM(I))/(REFLAM(I1)-REFLAM(I))
         U0=U(I)+(U(I1)-U(I))*DL
         V0=V(I)+(V(I1)-V(I))*DL
      ELSE
         GOTO 1
      END IF
      RETURN
      END
