C
C PURPOSE: TRAPEZOIDAL INTEGRATION OF EMISSION COEFFICIENTS ALONG LOS
C
C INPUTS:
C
C OUTPUTS:
C  EMERGE(KR,IM,NY)  - EMERGENT STOKES PARAMETERS IN ERG/CM2/S/SR/ANGSTROM
C
C COMMON: CSLINE, CCONST, CATOM, CINPUT
C
C RESTRICTIONS:  NONE
C
C COMMENTS: OCTOBER 6, 1999, P. JUDGE
C 
	SUBROUTINE TRAP(WT)
C
	INCLUDE 'PREC'
	INCLUDE 'PARAM'
	INCLUDE 'CINPUT'
	INCLUDE 'CSLINE'
	INCLUDE 'CATOM'
C
	DO KR=1,NLINE
	   IF ((ALAMB(KR) .GE. WLMIN) .AND. (ALAMB(KR) .LE. WLMAX)) THEN
              DO IM=0,4
                 DO NY=1,NQ(KR)
                    EMERGE(KR,IM,NY)=EMERGE(KR,IM,NY)+
     *              EMISS(KR,IM,NY)*WT
                 END DO
              END DO
           ENDIF
        END DO
	RETURN
	END
