C
C PURPOSE: COMPUTE INELASTIC MULTIPOLAR COLLISIONAL RATE
C
C INPUTS:
C       I    UPPER LEVEL INDEX
C       IL   LOWER LEVEL INDEX
C       K     MULTIPOLAR INDEX
C OUTPUTS:
C       GAMMAI
C COMMON:
C       CATOM CLU
C RESTRICTIONS:  THE TOTAL COLLISIONAL RATES C(I,I) ARE ASSUMED
C       TO BE THE RESULT OF 1 MULTIPOLE COMPONENT.  THIS MAY NOT BE 
C       CONSISTENT WITH THE INPUT DATA. SEE THE README FILE WITH THIS PROGRAM. 
C
C COMMENTS: OCTOBER 6, 1999, P. JUDGE
C EDITED: JULY 26 2019 P. JUDGE
C       CHANGED TO INTEGER DO-LOOP VARIABLES
C       CHANGED C(I,J) TO MEAN COLLISIONS FROM J TO I
C 
C ---Sept 2022 replaced pre 6jul22 version
C	
	FUNCTION GAMMAI(I,IL,K)
	INCLUDE 'PREC'
	INCLUDE 'PARAM'
	INCLUDE 'CSE'
	INCLUDE 'CLU'
	INCLUDE 'CATMOS'
	INCLUDE 'CATOM'
	INCLUDE 'CINPUT'
	INCLUDE 'CINTS'
	DATA ICALL /0/
	SAVE ICALL
	GAMMAI=ZERO
	IF(ICOLL .EQ. 0 .OR. IL.GE.I) RETURN
	IF(ICALL.EQ.0) THEN 
	   WRITE (LJOBLO,80)
 80	   FORMAT('GAMMAI AND GAMMAS:'/
     *     'E1 AND E2 TRANSITIONS, NO EXCHANGE OR STRONG COUPLING'/
     *     'OTHERS, STRONG COUPLING IS ASSUMED')
	   ICALL=ICALL+1
	ENDIF
	IF(ITTYPE(IL,I) .EQ. 1 .AND. K .EQ. 1) GAMMAI=C(I,IL)
	IF(ITTYPE(IL,I) .EQ. 2 .AND. K .EQ. 2) GAMMAI=C(I,IL)
	F=AJ(I) 
	FL=AJ(IL)
	FK=FLOAT(K)
C
C HERE WE ASSUME FOR SPIN-CHANGING AND STRONG COUPLING CASES
C THAT C(JL,I,N1,N) = C(JL,I)/(2*JL+1)
C CORRECTION 2019 June 3 PGJ, 
C THAT C(JL,I,N1,N) = C(JL,I)/(2*J+1)
C THIS IS FLAGGED FOR LEVELS JL AND J WHEN ITTYPE(JL,I) < ZERO
C 6 JUNE 2019: ADDED OPTION FOR ITTYPE=3
C
C       DIVIDE BY FINAL STATE 2J+1
C	TO CONSERVE PROBABILITY
C
	CASSUME=ZERO
	IF((ITTYPE(IL,I) .LT. 0 .OR. ITTYPE(IL,I) .GE. 3)
     *     .AND. ICOLL .NE. 2) 
     *    CASSUME=C(I,IL)/G(I)
C
C
C SKIP FURTHER CALCULATIONS IF NO MORE COLLISIONS ARE TO BE ADDED
C	
	IF(CASSUME .EQ. 0. .AND. ICOLLMM .EQ. 0) RETURN
C
C  CMM FORMALISM
C
C	THE VALUE OF CASSUME CONSERVES PROBABILITY WHEN THE COLLISION
C       CROSS SECTIONS ARE IDENTICAL BETWEEN SUBSTATES OF JUPPER AND JLOWER.
C	THE NOTATION IS ALWAYS C(A,B,M) ~ PROBABILITY OF MAKING A TRANSITION
C	** FROM LEVEL  B TO LEVEL A **
C
C       THIS IS THE EQUATION AFTER EQ (A4.2) OF LANDI DEGL'INNOCENTI
C	AND LANDOFI'S BOOK, FOR THE DIAGONAL CASE (NO COHERENCES, 
C       N=N', N''=N''').  THIS MEANS THAT THE GAMMAI COEFFICIENT
C	IS IDENTICALLY THE SUM OF COLLISION RATES C(JN,I'N') I.E.
C	TRANSFER OF *POPULATION* BETWEEN M-STATES
C
	NLO=INT(G(IL)-ONE)
	NUP=INT(G(I)-ONE)
	DO NL=-NLO,NLO,2
	   AL=FLOAT(NL)/2.
	   DO NU=-NUP,NUP,2
	      AU=FLOAT(NU)/2.
C
C EQUATION AFTER EQ (A4.2) OF LANDI DEGL'INNOCENTI, bottom page 800
C
	      DO M=0,K
		 P=FLOAT(M)
		 F3=FUN3J(FJ,FJL,FK,-AU,AL,P)
c 		 write(*,*) 'gammai ',K, M,F3 
		 GAMMAI=GAMMAI + (CMM(I,IL,NU/2,NL/2)+CASSUME) *F3*F3
     *                 * (TWO*FK+ONE)/G(IL)
	      ENDDO
	   ENDDO
	ENDDO
	IF(IDEBUG .NE. 0 .AND. GAMMAI .NE. 0.) THEN 
           WRITE(LOUT,*)
     *     'GAMMAI I,IL, K ',GAMMAI, I, IL, K
	   WRITE(LOUT,*)'ITTYPE  CASSUME ',ITTYPE(IL,I),CASSUME,C(IL,I)
	ENDIF
	RETURN
	END

