C
C PURPOSE: CALCULATES 3J VALUE, EACH RJ/RM IS REAL
C
C INPUTS:
C       RJ1,RJ2,RJ3  REAL J QUANTUM NUMBERS IN 1ST ROW OF 3J
C       RM1,RM2,RM3  REAL M QUANTUM NUMBERS IN 2ND ROW OF 3J
C OUTPUTS:
C       FUN3J
C COMMON:
C
C COMMENTS: OCTOBER 6, 1999, P. JUDGE
C 
	FUNCTION FUN3J(RJ1,RJ2,RJ3,RM1,RM2,RM3)
	INCLUDE 'PREC'
	INCLUDE 'PARAM'
	INCLUDE 'SGNM'
	INCLUDE 'CINTS'
	INCLUDE 'FACT'
C
	IJ1=NINT(RJ1+RJ1)
	IJ2=NINT(RJ2+RJ2)
	IJ3=NINT(RJ3+RJ3)
	IM1=NINT(RM1+RM1)
	IM2=NINT(RM2+RM2)
	IM3=NINT(RM3+RM3)
	FUN3J=ZERO
	IF(IJ1+IJ2-IJ3.LT.0) GOTO 1
	IF(IJ2+IJ3-IJ1.LT.0) GOTO 1
	IF(IJ3+IJ1-IJ2.LT.0) GOTO 1
	IF(IM1+IM2+IM3.NE.0) GOTO 1
	IF(IABS(IM1).GT.IJ1) GOTO 1
	IF(IABS(IM2).GT.IJ2) GOTO 1
	IF(IABS(IM3).GT.IJ3) GOTO 1
	KMIN=(IJ3-IJ1-IM2)/2
	KMIN1=KMIN
	KMIN2=(IJ3-IJ2+IM1)/2
	IF(KMIN2.LT.KMIN) KMIN=KMIN2
	KMIN=-KMIN
	IF(KMIN.LT.0) KMIN=0
	KMAX=NINT(RJ1+RJ2-RJ3)
	KMAX1=KMAX
	KMAX2=NINT(RJ1-RM1)
	KMAX3=NINT(RJ2+RM2)
	IF(KMAX2.LT.KMAX) KMAX=KMAX2
	IF(KMAX3.LT.KMAX) KMAX=KMAX3
	IF(KMIN.LE.KMAX) THEN
	  TERM=ZERO
	  TERM1=FN1(RJ1,RJ2,RJ3,RM1,RM2,RM3)
	  SGN=SG((IJ1-IJ2-IM3)/2)
	  DO I=KMIN,KMAX
	    TERM2=FL(I)+FL(KMIN1+I)+FL(KMIN2+I)
     /	    +FL(KMAX1-I)+FL(KMAX2-I)+FL(KMAX3-I)
	    TERM=SGN*SG(I)*EXP(TERM1-TERM2)
	    FUN3J=FUN3J+TERM
	  END DO
	END IF
 1	RETURN
	END
