C
C PURPOSE: GIVES QUADRATURE POINTS AND WEIGHTS FOR CONTINUA
C
C INPUTS:
C     KR  TRANSITION INDEX
C OUTPUTS:
C
C COMMON:
C     CATOM CSLINE CCONST
C
C COMMENTS: OCTOBER 6, 1999, P. JUDGE
C 
      SUBROUTINE FREQC(KR)
C
C  GIVES QUADRATURE POINTS AND WEIGHTS FOR CONTINUA
C  THE POINTS ARE EQUIDISTANT IN FREQUENCY, THE WEIGHTS ARE
C  TRAPEZOIDAL
C  CALCULATES CROSSECTIONS FROM NY**-3 DEPENDENCE IF NOT GIVEN
C  EXPLICITLY
C
C  QMAX .LT. 0 : Q AND ALFAC GIVEN (FROM ATOM INPUT). ONLY
C  WEIGHTS CALCULATED AND Q TRANSFORMED FROM ANGSTROM TO DOPPLER
C  UNITS.
C
C  NQ      TOTAL NUMBER OF QUADRATURE POINTS       (IN)
C  QMAX    MINIMUM VALUE OF WAVELENGTH (ANGSTROM)  (IN)
C  FRQ     QUADRATURE POINTS (S-1)                 (OUT)
C  Q       QUADRATURE POINTS (DOPPLER UNITS)       (OUT)
C  WQ      QUADRATURE WEIGHTS                      (OUT)
C
      INCLUDE 'PREC'
      INCLUDE 'PARAM'
      INCLUDE 'CATOM'
      INCLUDE 'CSLINE'
      INCLUDE 'CCONST'
C
      KT=KTRANS(KR)
      FRQ(0,KT)=CC/ALAMB(KR)*1.E8
      IF(QMAX(KR).GE.0.0) THEN
        FRQ(NQ(KR),KT)=CC/QMAX(KR)*1.E8
        DFRQ=(FRQ(NQ(KR),KT)-FRQ(0,KT))/(NQ(KR)-1)
        DO 100 NY=1,NQ(KR)
          FRQ(NY,KT)=FRQ(0,KT)+(NY-1)*DFRQ
          Q(NY,KR)=CC*1.E-5/QNORM*(FRQ(NY,KT)/FRQ(0,KT)-1.0)
          ALFAC(NY,KR-NLINE)=F(KR)*(FRQ(0,KT)/FRQ(NY,KT))**3
  100   CONTINUE
      ELSE
        DO 200 NY=1,NQ(KR)
          FRQ(NY,KT)=CC/Q(NY,KR)*1.0E8
          Q(NY,KR)=CC*1.0E-5/QNORM*(FRQ(NY,KT)/FRQ(0,KT)-1.0)
  200   CONTINUE
      ENDIF
C
      WQ(1,KR)=0.5*(Q(2,KR)-Q(1,KR))
      DO 300 NY=2,NQ(KR)-1
        WQ(NY,KR)=0.5*(Q(NY+1,KR)-Q(NY-1,KR))
  300 CONTINUE
      WQ(NQ(KR),KR)=0.5*(Q(NQ(KR),KR)-Q(NQ(KR)-1,KR))
C
      RETURN
      END
C
C******************************************************************
C
