C
C PURPOSE: COMPUTE COLLISION RATES C(6) FOR EQN (20) OF 
C          CASINI, R. & JUDGE, P. G., 1999. AP J 522, 524-539
C          A SUM OF INELASTIC COLLISIONS IS MADE FOR LEVELS GREATER
C          THAN IJ, FOR THE CASE K=0 ONLY.  
C          THE COMPLETE COEFFICIENT NEEDED FOR EQ. (20) IS 
C          BUILT BY SUMMING OUTSIDE OF THIS ROUTINE IN ROUTINE
C          SE0_BUILD
C INPUTS:
C          NJ       NUMBER OF LEVELS IN ATOM
C          IJ       INDEX OF LEVEL.  
C       
C OUTPUTS:
C          C6COEFF  
C COMMON:
C
C COMMENTS: OCTOBER 6, 1999, P. JUDGE
	SUBROUTINE C6(NJ,IJ,C6COEFF)
C  THIS SUBROUTINE CALCULATES THE COLLISIONAL RATES C(6)
	INCLUDE 'PREC'
	C6COEFF=0.0
	IZ=0
	DO IJ1=IJ+1,NJ
	  C6COEFF=CI(IJ1,IJ,IZ)+C6COEFF
	END DO
	RETURN
	END
