C
C PURPOSE: MAIN PROGRAM TO COMPUTE EMISSION COEFFS OF M1 CORONAL LINES
C          INTEGRATED ALONG THE LOS, FOR A SET OF LOS'S IN AN 
C          ASSIGNED GRID OF CARTESIAN COORDINATES.
C
C INPUTS:
C
C OUTPUTS:
C
C COMMON:
C
C COMMENTS: AUGUST 9, 2000 P. JUDGE
C 
      PROGRAM CLE
C
C  MAIN PROGRAM
C
C  CALCULATES THE EMISSION COEFFICIENTS OF FORBIDDEN CORONAL
C  LINES, INTEGRATED ALONG THE LOS, FOR A SET OF LOS'S IN AN 
C  ASSIGNED GRID OF CARTESIAN COORDINATES.
C
      INCLUDE 'PREC'
      INCLUDE 'PARAM'
      INCLUDE 'CGRID'
      INCLUDE 'CCONST'
      INCLUDE 'CBCNST'
      CALL CPTIME('TOTAL ',0,0,5)
C
      CALL START
C
C  LOOP ON THE LOS DISTRIBUTION
C
      GYSTEP=0.
      IF(NGY .NE. 1) GYSTEP=(GYMAX-GYMIN)/FLOAT(NGY-1)
      GZSTEP=(GZMAX-GZMIN)/FLOAT(NGZ-1)
      DO J=1,NGY
         WRITE(*,*)'DOING COLUMN Y=',J,'/',NGY,'...'
         CALL CPTIME('CLECOL',0,0,4)
         GY=FLOAT(J-1)*GYSTEP+GYMIN
         DO K=1,NGZ
            GZ=FLOAT(K-1)*GZSTEP+GZMIN
            CALL M1SYNTH(J,K)
            CALL OUTS(J,K)
         END DO
         CALL CPTIME('CLECOL',0,1,4)
      END DO
      CALL CPTIME('TOTAL ',0,1,5)
      CALL STOP('NORMAL END')
      END
      

